/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.StreamManipulator;
import multime.MultiME;

class OutputWindow {
    public int WINDOW_SIZE = 32768;
    public int WINDOW_MASK = this.WINDOW_SIZE - 1;
    public byte[] window = null;
    public int window_end = 0;
    public int window_filled = 0;

    OutputWindow() {
    }

    public void write(int n2) {
        if (this.window_filled++ == this.WINDOW_SIZE) {
            throw new IllegalStateException("Window full");
        }
        this.window[this.window_end++] = (byte)n2;
        this.window_end &= this.WINDOW_MASK;
    }

    public final void slowRepeat(int n2, int n3, int n4) {
        while (n3-- > 0) {
            this.window[this.window_end++] = this.window[n2++];
            this.window_end &= this.WINDOW_MASK;
            n2 &= this.WINDOW_MASK;
        }
    }

    public int copyStored(StreamManipulator streamManipulator, int n2) {
        int n3;
        int n4;
        if ((n2 = Math.min(Math.min(n2, this.WINDOW_SIZE - this.window_filled), streamManipulator.getAvailableBytes())) > (n4 = this.WINDOW_SIZE - this.window_end)) {
            n3 = streamManipulator.copyBytes(this.window, this.window_end, n4);
            if (n3 == n4) {
                n3 += streamManipulator.copyBytes(this.window, 0, n2 - n4);
            }
        } else {
            n3 = streamManipulator.copyBytes(this.window, this.window_end, n2);
        }
        this.window_end = this.window_end + n3 & this.WINDOW_MASK;
        this.window_filled += n3;
        return n3;
    }

    public void copyDict(byte[] byArray, int n2, int n3) {
        if (this.window_filled > 0) {
            throw new IllegalStateException();
        }
        if (n3 > this.WINDOW_SIZE) {
            n2 += n3 - this.WINDOW_SIZE;
            n3 = this.WINDOW_SIZE;
        }
        System.arraycopy(byArray, n2, this.window, 0, n3);
        this.window_end = n3 & this.WINDOW_MASK;
    }

    public int getFreeSpace() {
        return this.WINDOW_SIZE - this.window_filled;
    }

    public int getAvailable() {
        return this.window_filled;
    }

    public int copyOutput(byte[] byArray, int n2, int n3) {
        int n4 = this.window_end;
        if (n3 > this.window_filled) {
            n3 = this.window_filled;
        } else {
            n4 = this.window_end - this.window_filled + n3 & this.WINDOW_MASK;
        }
        int n5 = n3;
        int n6 = n3 - n4;
        if (n6 > 0) {
            System.arraycopy(this.window, this.WINDOW_SIZE - n6, byArray, n2, n6);
            n2 += n6;
            n3 = n4;
        }
        System.arraycopy(this.window, n4 - n3, byArray, n2, n3);
        this.window_filled -= n5;
        if (this.window_filled < 0) {
            throw new IllegalStateException();
        }
        return n5;
    }

    public void reset() {
        this.window_end = 0;
        this.window_filled = 0;
    }

    static {
        MultiME.classLoaded("jazzlib.OutputWindow");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.OutputWindow");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

