/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.DataFormatException;
import jazzlib.InflaterHuffmanTree;
import jazzlib.StreamManipulator;
import multime.MultiME;

class InflaterDynHeader {
    private static final int LNUM = 0;
    private static final int DNUM = 1;
    private static final int BLNUM = 2;
    private static final int BLLENS = 3;
    private static final int LENS = 4;
    private static final int REPS = 5;
    private static final int[] repMin;
    private static final int[] repBits;
    private byte[] blLens;
    private byte[] litdistLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int num;
    private int repSymbol;
    private byte lastLen;
    private int ptr;
    private static final int[] BL_ORDER;

    public boolean decode(StreamManipulator streamManipulator) throws DataFormatException {
        block8: while (true) {
            switch (this.mode) {
                case 0: {
                    int n2 = streamManipulator.bits_in_buffer < 5 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 0x1F) : (this.lnum = streamManipulator.buffer & 0x1F);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    streamManipulator.buffer >>>= 5;
                    streamManipulator.bits_in_buffer -= 5;
                    this.mode = 1;
                }
                case 1: {
                    int n3 = streamManipulator.bits_in_buffer < 5 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 0x1F) : (this.dnum = streamManipulator.buffer & 0x1F);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    streamManipulator.buffer >>>= 5;
                    streamManipulator.bits_in_buffer -= 5;
                    this.num = this.lnum + this.dnum;
                    this.litdistLens = new byte[this.num];
                    this.mode = 2;
                }
                case 2: {
                    int n4 = streamManipulator.bits_in_buffer < 4 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 0xF) : (this.blnum = streamManipulator.buffer & 0xF);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    streamManipulator.buffer >>>= 4;
                    streamManipulator.bits_in_buffer -= 4;
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    int n5;
                    while (this.ptr < this.blnum) {
                        int n6 = streamManipulator.bits_in_buffer < 3 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 7) : (n5 = streamManipulator.buffer & 7);
                        if (n5 < 0) {
                            return false;
                        }
                        streamManipulator.buffer >>>= 3;
                        streamManipulator.bits_in_buffer -= 3;
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)n5;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    int n5;
                    while (((n5 = this.blTree.getSymbol(streamManipulator)) & 0xFFFFFFF0) == 0) {
                        this.litdistLens[this.ptr++] = this.lastLen = (byte)n5;
                        if (this.ptr != this.num) continue;
                        return true;
                    }
                    if (n5 < 0) {
                        return false;
                    }
                    if (n5 >= 17) {
                        this.lastLen = 0;
                    } else if (this.ptr == 0) {
                        throw new DataFormatException();
                    }
                    this.repSymbol = n5 - 16;
                    this.mode = 5;
                }
                case 5: {
                    int n7;
                    int n5 = repBits[this.repSymbol];
                    int n8 = streamManipulator.bits_in_buffer < n5 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n5) - 1) : (n7 = streamManipulator.buffer & (1 << n5) - 1);
                    if (n7 < 0) {
                        return false;
                    }
                    streamManipulator.buffer >>>= n5;
                    streamManipulator.bits_in_buffer -= n5;
                    if (this.ptr + (n7 += repMin[this.repSymbol]) > this.num) {
                        throw new DataFormatException();
                    }
                    while (n7-- > 0) {
                        this.litdistLens[this.ptr++] = this.lastLen;
                    }
                    if (this.ptr == this.num) {
                        return true;
                    }
                    this.mode = 4;
                    continue block8;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() throws DataFormatException {
        byte[] byArray = new byte[this.lnum];
        System.arraycopy(this.litdistLens, 0, byArray, 0, this.lnum);
        return new InflaterHuffmanTree(byArray);
    }

    public InflaterHuffmanTree buildDistTree() throws DataFormatException {
        byte[] byArray = new byte[this.dnum];
        System.arraycopy(this.litdistLens, this.lnum, byArray, 0, this.dnum);
        return new InflaterHuffmanTree(byArray);
    }

    static {
        MultiME.classLoaded("jazzlib.InflaterDynHeader");
        repMin = new int[]{3, 3, 11};
        repBits = new int[]{2, 3, 7};
        BL_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.InflaterDynHeader");
        repMin = new int[]{3, 3, 11};
        repBits = new int[]{2, 3, 7};
        BL_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    }

    public static void staticSuperCleaningRoutine() {
    }
}

