/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.Checksum;
import multime.MultiME;

public class CRC32
implements Checksum {
    private int crc = 0;
    private static int[] crc_table;

    private static int[] make_crc_table() {
        int[] nArray = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = i2;
            int n3 = 8;
            while (--n3 >= 0) {
                if ((n2 & 1) != 0) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            nArray[i2] = n2;
        }
        return nArray;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int n2) {
        int n3 = ~this.crc;
        n3 = crc_table[(n3 ^ n2) & 0xFF] ^ n3 >>> 8;
        this.crc = ~n3;
    }

    public void update(byte[] byArray, int n2, int n3) {
        int n4 = ~this.crc;
        while (--n3 >= 0) {
            n4 = crc_table[(n4 ^ byArray[n2++]) & 0xFF] ^ n4 >>> 8;
        }
        this.crc = ~n4;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    static {
        MultiME.classLoaded("jazzlib.CRC32");
        crc_table = CRC32.make_crc_table();
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.CRC32");
        crc_table = CRC32.make_crc_table();
    }

    public static void staticSuperCleaningRoutine() {
        crc_table = null;
    }
}

